unit Popup1u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Menu: TMenuItem;
    SzinesSzoveg: TMenuItem;
    Keret: TMenuItem;
    Keretszin: TMenuItem;
    S: TMenuItem;
    Hanggal: TMenuItem;
    HangNelkul: TMenuItem;
    Kilepes: TMenuItem;
    SzovegTorles: TMenuItem;
    N1: TMenuItem;
    PopupMenu1: TPopupMenu;
    PopupSzinesSzoveg: TMenuItem;
    PopupKeret: TMenuItem;
    PopupKeretszin: TMenuItem;
    procedure HanggalClick(Sender: TObject);
    procedure HangNelkulClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure SzinesSzovegClick(Sender: TObject);
    procedure KeretClick(Sender: TObject);
    procedure KeretszinClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure SzovegTorlesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Szines     : boolean;
  SzovegKeret: boolean;
  Keretszine : integer;
  Megjelenites: integer;
implementation

{$R *.DFM}

procedure TForm1.HanggalClick(Sender: TObject);
begin
   Megjelenites := 1;
   Invalidate;
end;

procedure TForm1.HangNelkulClick(Sender: TObject);
begin
    Megjelenites := 2;
    Invalidate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Left := 200;
   Top  := 100;
   // a Men "Sznes szveg" menpont kijellsekor
   // petty jelenik meg
   SzinesSzoveg.RadioItem := true;
   // adatmezk kezdrknek belltsa
   Szines := false;
   SzovegKeret := true;
   Keretszine := 0;
   Megjelenites := 0;
   Canvas.Brush.Color := clWhite;
   Canvas.Font.Color  := clBlack;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.SzinesSzovegClick(Sender: TObject);
begin
  Szines := not Szines;
  // a Men "Sznes szveg" menpontja pettyel, illetve
  // illetve ptty nlkl
  SzinesSzoveg.Checked := Szines;
  // a legrdl menben a "Sznes szveg" menpont pipval,
  // illetve a pipa nlkl
  PopupSzinesSzoveg.Checked := Szines;
  Invalidate;
end;

procedure TForm1.KeretClick(Sender: TObject);
begin
  SzovegKeret := not SzovegKeret;
  if SzovegKeret then
  begin
    Keret.Caption := '&Keret nlkl';
    Keretszin.Enabled := true;
    // a legrdl men egyidej lltsa
    PopupKeret.Caption := '&Keret nlkl';
    PopupKeretszin.Enabled := true;
  end
  else
  begin
    Keret.Caption := '&Kerettel';
    Keretszin.Enabled := false;
    // a legrdl men egyidej lltsa
    PopupKeret.Caption := '&Kerettel';
    PopupKeretszin.Enabled := false;
  end;
  Invalidate;
end;

procedure TForm1.KeretszinClick(Sender: TObject);
begin
   Keretszine := (Keretszine+1) mod 4;
   // jrafestsi krelem
   Invalidate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Canvas.Pen.Color := clWhite;
  if SzovegKeret then
  begin
    // a keretszin kivlasztsa
    case Keretszine of
      0 : Canvas.Brush.Color :=  clYellow;
      1 : Canvas.Brush.Color := clBlue;
      2 : Canvas.Brush.Color := clGreen;
      3 : Canvas.Brush.Color := clPurple;
    end;
    Canvas.Rectangle(110,110,200,200);
    Canvas.Brush.Color := clWhite;
    Canvas.Rectangle(115,115,194,194);
   end
   else
   begin
     Canvas.Brush.Color := clWhite;
     Canvas.Rectangle(105,105,204,204);
   end;
   if Megjelenites = 0 then
   begin
     Canvas.Font.Color := clWhite;
     Canvas.TextOut(130,130,'DELPHI');
   end
   else
   begin
     if Szines then
       Canvas.Font.Color := clRed
     else
       Canvas.Font.Color := clBlack;
      if Megjelenites = 1 then beep;
      Canvas.TextOut(130,130,'DELPHI');
    end;
  end;

procedure TForm1.SzovegTorlesClick(Sender: TObject);
begin
  Megjelenites := 0;
  Invalidate;
end;

end.
